/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.CJPacketTooBigException;
import com.mysql.cj.mysqlx.io.ErrorToFutureSentListener;
import com.mysql.cj.mysqlx.io.MessageWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class AsyncMessageWriter
implements CompletionHandler<Long, Void>,
MessageWriter {
    private static final int HEADER_LEN = 5;
    private AsynchronousSocketChannel channel;
    private int maxAllowedPacket = -1;
    private Queue<ByteBuffer> pendingWrites = new LinkedList<ByteBuffer>();
    private Map<Integer, SentListener> bufToListener = new ConcurrentHashMap<Integer, SentListener>();

    public AsyncMessageWriter(AsynchronousSocketChannel channel) {
        this.channel = channel;
    }

    private void initiateWrite() {
        try {
            ByteBuffer[] bufs = this.pendingWrites.toArray(new ByteBuffer[this.pendingWrites.size()]);
            this.channel.write(bufs, 0, this.pendingWrites.size(), 0L, TimeUnit.MILLISECONDS, null, this);
        }
        catch (Throwable t) {
            this.failed(t, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessage(ByteBuffer messageBuf, SentListener callback) {
        if (callback != null) {
            this.bufToListener.put(System.identityHashCode(messageBuf), callback);
        }
        Queue<ByteBuffer> queue = this.pendingWrites;
        synchronized (queue) {
            this.pendingWrites.add(messageBuf);
            if (this.pendingWrites.size() == 1) {
                this.initiateWrite();
            }
        }
    }

    @Override
    public void write(MessageLite msg) {
        CompletableFuture f2 = new CompletableFuture();
        this.writeAsync(msg, new ErrorToFutureSentListener(f2, () -> f2.complete(null)));
        try {
            f2.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException("Failed to write message", ex);
        }
    }

    public void writeAsync(MessageLite msg, SentListener callback) {
        int type = MessageWriter.getTypeForMessageClass(msg.getClass());
        int size = msg.getSerializedSize();
        int payloadSize = size + 1;
        if (this.maxAllowedPacket > 0 && payloadSize > this.maxAllowedPacket) {
            throw new CJPacketTooBigException(size, this.maxAllowedPacket);
        }
        ByteBuffer messageBuf = ByteBuffer.allocate(5 + size).order(ByteOrder.LITTLE_ENDIAN).putInt(payloadSize);
        messageBuf.put((byte)type);
        try {
            msg.writeTo(CodedOutputStream.newInstance((byte[])messageBuf.array(), (int)5, (int)(size + 5)));
        }
        catch (IOException ex) {
            throw new CJCommunicationsException("Unable to write message", ex);
        }
        messageBuf.rewind();
        this.queueMessage(messageBuf, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Long bytesWritten, Void v) {
        if (bytesWritten == 0L) {
            throw new IllegalArgumentException("Shouldn't be 0");
        }
        LinkedList<ByteBuffer> completedWrites = new LinkedList<ByteBuffer>();
        Queue<ByteBuffer> queue = this.pendingWrites;
        synchronized (queue) {
            while (this.pendingWrites.peek() != null && !this.pendingWrites.peek().hasRemaining()) {
                completedWrites.add(this.pendingWrites.remove());
            }
            completedWrites.stream().map(System::identityHashCode).map(this.bufToListener::remove).filter(Objects::nonNull).forEach(l2 -> {
                try {
                    l2.completed();
                }
                catch (Throwable ex) {
                    try {
                        l2.error(ex);
                    }
                    catch (Throwable ex2) {
                        ex2.printStackTrace();
                    }
                }
            });
            if (this.pendingWrites.size() > 0) {
                this.initiateWrite();
            }
        }
    }

    @Override
    public void failed(Throwable t, Void v) {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bufToListener.values().forEach(l2 -> {
            try {
                l2.error(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.bufToListener.clear();
        this.pendingWrites.clear();
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
    }

    @FunctionalInterface
    public static interface SentListener {
        public void completed();

        default public void error(Throwable ex) {
            ex.printStackTrace();
        }
    }
}

