/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bson.BSONException;

public abstract class OutputBuffer
extends OutputStream {
    public abstract void write(byte[] var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public abstract void write(int var1);

    public abstract int getPosition();

    @Deprecated
    public abstract void setPosition(int var1);

    @Deprecated
    public abstract void seekEnd();

    @Deprecated
    public abstract void seekStart();

    public abstract int size();

    public abstract int pipe(OutputStream var1) throws IOException;

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.size());
            this.pipe(bout);
            return bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    @Deprecated
    public String asString() {
        return new String(this.toByteArray());
    }

    @Deprecated
    public String asString(String encoding) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), encoding);
    }

    @Deprecated
    public String hex() {
        final StringBuilder buf = new StringBuilder();
        try {
            this.pipe(new OutputStream(){

                public void write(int b) {
                    String s = Integer.toHexString(0xFF & b);
                    if (s.length() < 2) {
                        buf.append("0");
                    }
                    buf.append(s);
                }
            });
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible");
        }
        return buf.toString();
    }

    @Deprecated
    public String md5() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error - this implementation of Java doesn't support MD5.");
        }
        md5.reset();
        try {
            this.pipe(new OutputStream(){

                public void write(byte[] b, int off, int len) {
                    md5.update(b, off, len);
                }

                public void write(int b) {
                    md5.update((byte)(b & 0xFF));
                }
            });
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible");
        }
        return Util.toHex(md5.digest());
    }

    public void writeInt(int x) {
        this.write(x >> 0);
        this.write(x >> 8);
        this.write(x >> 16);
        this.write(x >> 24);
    }

    @Deprecated
    public void writeIntBE(int x) {
        this.write(x >> 24);
        this.write(x >> 16);
        this.write(x >> 8);
        this.write(x);
    }

    @Deprecated
    public void writeInt(int pos, int x) {
        int save = this.getPosition();
        this.setPosition(pos);
        this.writeInt(x);
        this.setPosition(save);
    }

    public void writeLong(long x) {
        this.write((byte)(0xFFL & x >> 0));
        this.write((byte)(0xFFL & x >> 8));
        this.write((byte)(0xFFL & x >> 16));
        this.write((byte)(0xFFL & x >> 24));
        this.write((byte)(0xFFL & x >> 32));
        this.write((byte)(0xFFL & x >> 40));
        this.write((byte)(0xFFL & x >> 48));
        this.write((byte)(0xFFL & x >> 56));
    }

    public void writeDouble(double x) {
        this.writeLong(Double.doubleToRawLongBits(x));
    }

    public void writeString(String str) {
        this.writeInt(0);
        int strLen = this.writeCString(str, false);
        this.backpatchSize(strLen, 4);
    }

    public int writeCString(String str) {
        return this.writeCString(str, true);
    }

    private int writeCString(String str, boolean checkForNullCharacters) {
        int c;
        int len = str.length();
        int total = 0;
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = Character.codePointAt(str, i);
            if (checkForNullCharacters && c == 0) {
                throw new BSONException(String.format("BSON cstring '%s' is not valid because it contains a null character at index %d", str, i));
            }
            if (c < 128) {
                this.write((byte)c);
                ++total;
                continue;
            }
            if (c < 2048) {
                this.write((byte)(192 + (c >> 6)));
                this.write((byte)(128 + (c & 0x3F)));
                total += 2;
                continue;
            }
            if (c < 65536) {
                this.write((byte)(224 + (c >> 12)));
                this.write((byte)(128 + (c >> 6 & 0x3F)));
                this.write((byte)(128 + (c & 0x3F)));
                total += 3;
                continue;
            }
            this.write((byte)(240 + (c >> 18)));
            this.write((byte)(128 + (c >> 12 & 0x3F)));
            this.write((byte)(128 + (c >> 6 & 0x3F)));
            this.write((byte)(128 + (c & 0x3F)));
            total += 4;
        }
        this.write(0);
        return ++total;
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }

    public void backpatchSize(int size) {
        this.writeInt(this.getPosition() - size, size);
    }

    protected void backpatchSize(int size, int additionalOffset) {
        this.writeInt(this.getPosition() - size - additionalOffset, size);
    }

    public void truncateToPosition(int newPosition) {
        this.setPosition(newPosition);
    }
}

